@extends('backend.layout.master')
@section('title', __('All Cities'))
@section('style')
    <x-select2.select2-css/>
@endsection
@section('content')
    <div class="dashboard__body">
        <div class="row">
            <div class="col-lg-12">
                <div class="customMarkup__single">
                    <div class="customMarkup__single__item">
                        <div class="customMarkup__single__item__flex">
                            <h4 class="customMarkup__single__title">{{ __('All Cities') }}</h4>
                            @can('city-add')
                            <x-btn.add-modal :title="__('Add City')" />
                            @endcan
                        </div>
                        <div class="search_delete_wrapper">
                            @can('city-bulk-delete')
                            <x-bulk-action.bulk-action />
                            @endcan
                            <x-search.search-in-table :id="'string_search'" />
                        </div>
                        <div class="customMarkup__single__inner mt-4">
                            <!-- Table Start -->
                            <div class="custom_table style-04 search_result">
                                @include('countrymanage::city.search-result')
                            </div>
                            <!-- Table End -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('countrymanage::city.add-modal')
    @include('countrymanage::city.edit-modal')
@endsection

@section('script')
    <x-sweet-alert.sweet-alert2-js/>
    <x-select2.select2-js/>
    <x-bulk-action.bulk-delete-js :url="route('admin.city.delete.bulk.action')"/>
    @include('countrymanage::city.city-js')

@endsection
