<script>
    (function($){
        "use strict";
        $(document).ready(function(){

            // search category
            $(document).on('keyup','#string_search',function(){
                let string_search = $(this).val();
                $.ajax({
                    url:"{{ route('admin.profile.promote.search') }}",
                    method:'GET',
                    data:{string_search:string_search},
                    success:function(res){
                        if(res.status=='nothing'){
                            $('.search_result').html('<h3 class="text-center text-danger">'+"{{ __('Nothing Found') }}"+'</h3>');
                        }else{
                            $('.search_result').html(res);
                        }
                    }
                });
            })

            // pagination
            $(document).on('click', '.pagination a', function(e){
                e.preventDefault();
                let string_search = $('#string_search').val();
                let page = $(this).attr('href').split('page=')[1];
                promotion_search(page,string_search);
            });
            function promotion_search(page,string_search){
                $.ajax({
                    url:"{{ route('admin.profile.promote.paginate').'?page='}}" + page,
                    data:{string_search:string_search},
                    success:function(res){
                        $('.search_result').html(res);
                    }
                });
            }

            //edit manual payment promotion
            $(document).on('click','.edit_payment_gateway_modal',function(){
                let promoted_profile_list_id = $(this).data('promoted-profile-list-id');
                let promoted_profile_user_id = $(this).data('promoted-profile-user-id');
                let img_name = $(this).data('img-url');

                $('#promoted_profile_list_id').val(promoted_profile_list_id)
                $('#promoted_profile_user_id').val(promoted_profile_user_id)
                let manual_payment_image = "{{ url('/assets/uploads/manual-payment/promotion') }}/" + img_name;
                let extension = img_name.slice((img_name.lastIndexOf(".") - 1 >>> 0) + 2);

                if (extension.toLowerCase() === 'pdf') {
                    $('.manual_payment_img').html(`<a href="${manual_payment_image}" class="text-primary" download">{{ __('Download Pdf') }}</a>`);
                } else {
                    $('.manual_payment_img').html(`<img src="${manual_payment_image}" alt="{{ __('Manual Payment Image') }}">`);
                }

                {{--if(img_name == ''){--}}
                {{--    $('.manual_payment_image_display').hide();--}}
                {{--}else{--}}
                {{--    $('.manual_payment_image_display').show();--}}
                {{--    let manual_payment_image = "{{ url('/assets/uploads/manual-payment/promotion') }}/" + img_name;--}}
                {{--    $('.manual_payment_img').attr('src', manual_payment_image);--}}
                {{--}--}}
            })

        });
    }(jQuery));

    //toastr warning
    function toastr_warning_js(msg){
        Command: toastr["warning"](msg, "Warning !")
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "newestOnTop": false,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }
    }

</script>
