<div class="dashboard__header">
    <div class="dashboard__header__flex">
        <div class="dashboard__header__left">
            <h4 class="dashboard__header__title">{{ Auth::guard('admin')->user()->name ?? '' }}</h4>
            <a href="{{ url('/') }}" class="dashboard__header__para mt-2">{{ __('Here\'s what\'s going on in') }} {{ get_static_option('site_title') }}</a>
        </div>
        <div class="dashboard__header__right">
            <div class="dashboard__header__right__flex">
                <div class="dashboard__header__right__item">
                    <a target="_blank" href="{{ url('/') }}" class="visitSite__btn">{{ __('Visit Site') }}</a>
                </div>
                <div class="dashboard__header__right__item">
                    <div class="dashboard__author">
                        <a href="javascript:void(0)" class="dashboard__author__flex flex-btn">
                            <div class="dashboard__author__thumb">
                                @if(Auth::guard('admin')->check() && !empty(Auth::guard('admin')->user()->image))
                                    {!! render_image_markup_by_attachment_id(Auth::guard('admin')->user()->image,'','thumb') !!}
                                @else
                                    <img src="{{ asset('assets/static/img/author/author.jpg') }}" alt="{{ __('admin img') }}">
                                @endif
                            </div>
                        </a>
                        <div class="dashboard__author__wrapper">
                            <div class="dashboard__author__wrapper__list">
                                @if(Auth::check() && Auth::guard('admin')->user()->role == '1')
                                <a href="{{ route('admin.all') }}" class="dashboard__author__wrapper__list__item"><i class="fa-solid fa-gear"></i>{{ __('Admin settings') }}</a>
                                <a href="{{ route('admin.edit', Auth::user()->id) }}" class="dashboard__author__wrapper__list__item">
                                    <i class="fa-solid fa-user-pen"></i> {{ __('Edit Profile') }}
                                </a>

                                <a class="btn dropdown-item dashboard__author__wrapper__list__item change_admin_password"
                                    data-bs-target="#adminPasswordModal"
                                    data-bs-toggle="modal"
                                    data-admin-id="{{ Auth::user()->id }}">
                                    <i class="fa-solid fa-key"></i>
                                    {{ __('Change Password') }}
                                </a>
                                @endif
                                <a href="{{ route('admin.logout') }}" class="dashboard__author__wrapper__list__item"><i class="fa-solid fa-arrow-right-from-bracket"></i>{{ __('Log Out') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="dashboard__header__right__item">
                    <div class="dashboard__notification">
                        <a href="javascript:void(0)" class="dashboard__notification__icon">
                                <i class="fa-solid fa-bell"></i>
                                <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">{{ App\Models\AdminNotification::where('is_read', 'unread')->get()->count() }}</span>
                        </a>
                        <div class="dashboard__notification__wrapper">
                            <div class="dashboard__notification__list">
                                @foreach(App\Models\AdminNotification::last_50_notification() as $notification)
                                  <x-backend.admin-notification :notification="$notification"/>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('rolepermission::admin-manage.password-modal')