@extends('frontend.layout.master')
@section('content')
    <!-- login Area Starts -->
    <section class="login-area pat-100 pab-100">
        <div class="container">
            <div class="row gy-5 align-items-center justify-content-between">
                <div class="offset-md-3 col-md-6">
                    <div class="login-wrapper">
                        <div class="login-wrapper-contents">
                            <h3 class="login-wrapper-contents-title">{{ __('Enter 2FA OTP Code ') }}</h3>
                            <span
                                class="text-info">{{ __('Please open your google authenticator app and enter the given OTP code') }}</span>
                            <x-validation.error />
                            <div class="error-message"></div>
                            <form class="login-wrapper-contents-form custom-form signup-forms" method="post"
                                action="{{ route('client._2fa.verify.code') }}">
                                @csrf
                                <div class="single-input mt-4">
                                    <input class="form--control" type="text" name="one_time_password"
                                        id="one_time_password" placeholder="{{ __('Enter Verification Code') }}">
                                </div>
                                <x-btn.submit :title="__('Verify Account')" :class="'submit-btn w-100 mt-4'" />
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- login Area end -->
@endsection


{{-- register script --}}
@section('script')
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {
                $(document).on('click', '#signin_form', function(e) {
                    e.preventDefault();
                    let el = $(this);
                    let erContainer = $(".error-message");
                    erContainer.html('');
                    el.text('{{ __('Please Wait..') }}');
                    $.ajax({
                        url: "{{ route('user.login') }}",
                        type: "POST",
                        data: {
                            username: $('#username').val(),
                        },
                        error: function(data) {
                            var errors = data.responseJSON;
                            erContainer.html('<div class="alert alert-danger"></div>');
                            $.each(errors.errors, function(index, value) {
                                erContainer.find('.alert.alert-danger').append(
                                    '<p>' + value + '</p>');
                            });
                            el.text('{{ __('Login') }}');
                        },
                        success: function(data) {
                            $('.alert.alert-danger').remove();
                            if (data.status == 'client-login') {
                                el.text('{{ __('Redirecting') }}..');
                                erContainer.html('<div class="alert alert-' + data.type +
                                    '">' + data.msg + '</div>');
                                let redirectPath = "{{ route('client.profile') }}";
                                @if (!empty(request()->get('return')))
                                    redirectPath =
                                    "{{ url('/' . request()->get('return')) }}";
                                @endif
                                window.location = redirectPath;
                            } else if (data.status == 'freelancer-login') {
                                el.text('{{ __('Redirecting') }}..');
                                erContainer.html('<div class="alert alert-' + data.type +
                                    '">' + data.msg + '</div>');
                                let redirectPath = "{{ route('influencer.profile') }}";

                                @if (!empty(request()->get('return')))
                                    redirectPath =
                                        "{{ url('/' . request()->get('return')) }}";
                                @endif

                                window.location = redirectPath;
                            } else {
                                erContainer.html('<div class="alert alert-' + data.type +
                                    '">' + data.msg + '</div>');
                                el.text('{{ __('Login') }}');
                            }
                        }
                    });
                });
            });
        }(jQuery));
    </script>
@endsection
