@extends('frontend.layout.master')
@section('site_title',__('Create Shake'))
@section('style')
    <x-summernote.summernote-css />
    <x-select2.select2-css/>
    <x-media.css/>
@endsection
@section('content')
<main>
   <x-breadcrumb.user-profile-breadcrumb :title="__('Create Project')" :innerTitle="__('Create Project')"/>
    <!-- Account Setup area Starts -->
    <div class="account-area pat-100 pab-100">
        <div class="container">
            <div class="setup-wrapper create-project-wrap">
                <div class="setup-wrapper-flex">
                    @include('frontend.user.influencer.project.create.project-sidebar')
                    <div class="create-project-wrapper border-all">
                        <x-validation.error />
                         <form action="{{ route('influencer.project.create') }}" id="submit_create_project_form" method="post" enctype="multipart/form-data">
                            @csrf
                             <input type="hidden" name="basic_title" id="set_basic_title" value="Basic">
                             <input type="hidden" name="standard_title" id="set_standard_title" value="Standard">
                             <input type="hidden" name="premium_title" id="set_premium_title" value="Premium">

                            @include('frontend.user.influencer.project.create.project-introduction')
                            @include('frontend.user.influencer.project.create.project-image')
                            @include('frontend.user.influencer.project.create.project-package-charge')
                            @include('frontend.user.influencer.project.create.project-footer')
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Account Setup area end -->
    <x-media.markup :type="'influencer'"/>
</main>
@endsection

@section('script')
    <x-sweet-alert.sweet-alert2-js/>
   @include('frontend.user.influencer.project.create.project-js')
   <x-summernote.summernote-js-function />
   <x-media.js :type="'influencer'"/>
   <script>
       initializeSummernote($('.description'), {
           onKeyup: function(e) {
               setTimeout(function(){
                   let description_min_length = 50;
                   let project_description_length = $('#project_description').val().length;

                   if(project_description_length < description_min_length){
                       $('#project_description_char_length_check').html('<p class="text text-danger">{{ __('Length is short, minimum ') }}'+ description_min_length +' {{ __('required') }}.</p>');
                   }else{
                       $('#project_description_char_length_check').html('<p class="text text-success">{{ __('Length is valid') }}</p>');
                   }
               },200);
           }
       })
   </script>

   <x-select2.select2-js />
@endsection
