<?php //74c4f4f9c81ebc882aaae59c08006f59
/** @noinspection all */

namespace Modules\Blog\Entities {

    use App\Models\Admin;
    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Admin_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogComment_C;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogComment_QB;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogPost_C;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogPost_QB;
    use LaravelIdea\Helper\Modules\Pages\Entities\_IH_MetaData_QB;
    use LaravelIdea\Helper\Modules\Service\Entities\_IH_Category_QB;
    use Modules\Pages\Entities\MetaData;
    use Modules\Service\Entities\Category;
    
    /**
     * @property int $id
     * @property int $blog_post_id
     * @property int|null $user_id
     * @property string $name
     * @property string $email
     * @property string $comment
     * @property int $status 0=pending, 1=approved
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property BlogPost $blogPost
     * @method BelongsTo|_IH_BlogPost_QB blogPost()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_BlogComment_QB onWriteConnection()
     * @method _IH_BlogComment_QB newQuery()
     * @method static _IH_BlogComment_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_BlogComment_QB query()
     * @method static _IH_BlogComment_QB with(array|string $relations)
     * @method _IH_BlogComment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlogComment_C|BlogComment[] all($columns = ['*'])
     * @ownLinks blog_post_id,\Modules\Blog\Entities\BlogPost,id|user_id,\App\Models\User,id
     * @mixin _IH_BlogComment_QB
     */
    class BlogComment extends Model {}
    
    /**
     * @property int $id
     * @property int $category_id
     * @property int $admin_id
     * @property string $title
     * @property string|null $slug
     * @property string $content
     * @property string $image
     * @property int|null $views
     * @property int $status 0=inactive, 1=active
     * @property string|null $tag_name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Admin $author
     * @method BelongsTo|_IH_Admin_QB author()
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_BlogComment_C|BlogComment[] $comments
     * @property-read int $comments_count
     * @method HasMany|_IH_BlogComment_QB comments()
     * @property MetaData $meta_data
     * @method MorphToMany|_IH_MetaData_QB meta_data()
     * @method static _IH_BlogPost_QB onWriteConnection()
     * @method _IH_BlogPost_QB newQuery()
     * @method static _IH_BlogPost_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_BlogPost_QB query()
     * @method static _IH_BlogPost_QB with(array|string $relations)
     * @method _IH_BlogPost_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlogPost_C|BlogPost[] all($columns = ['*'])
     * @ownLinks category_id,\Modules\Service\Entities\Category,id|admin_id,\App\Models\Admin,id
     * @foreignLinks id,\Modules\Blog\Entities\BlogComment,blog_post_id
     * @mixin _IH_BlogPost_QB
     */
    class BlogPost extends Model {}
}