<?php //4d7583763b81a5e9a1f2858e3c301bfe
/** @noinspection all */

namespace Modules\Chat\Entities {

    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_LiveChatMessage_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_LiveChatMessage_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_LiveChat_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_LiveChat_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_OfferMilestone_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_OfferMilestone_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Offer_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Offer_QB;
    
    /**
     * @property int $id
     * @property int|null $client_id
     * @property int|null $freelancer_id
     * @property int|null $admin_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $client
     * @method BelongsTo|_IH_User_QB client()
     * @property _IH_LiveChatMessage_C|LiveChatMessage[] $client_unseen_msg
     * @property-read int $client_unseen_msg_count
     * @method HasMany|_IH_LiveChatMessage_QB client_unseen_msg()
     * @property User|null $freelancer
     * @method BelongsTo|_IH_User_QB freelancer()
     * @property _IH_LiveChatMessage_C|LiveChatMessage[] $freelancer_unseen_msg
     * @property-read int $freelancer_unseen_msg_count
     * @method HasMany|_IH_LiveChatMessage_QB freelancer_unseen_msg()
     * @property _IH_LiveChatMessage_C|LiveChatMessage[] $livechatMessage
     * @property-read int $livechat_message_count
     * @method HasMany|_IH_LiveChatMessage_QB livechatMessage()
     * @method static _IH_LiveChat_QB onWriteConnection()
     * @method _IH_LiveChat_QB newQuery()
     * @method static _IH_LiveChat_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_LiveChat_QB query()
     * @method static _IH_LiveChat_QB with(array|string $relations)
     * @method _IH_LiveChat_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LiveChat_C|LiveChat[] all($columns = ['*'])
     * @ownLinks admin_id,\App\Models\Admin,id
     * @foreignLinks id,\Modules\Chat\Entities\LiveChatMessage,live_chat_id
     * @mixin _IH_LiveChat_QB
     */
    class LiveChat extends Model {}
    
    /**
     * @property int $id
     * @property int $live_chat_id
     * @property int $from_user 1 = client, 2 = freelancer, 3 = admin
     * @property array $message
     * @property string|null $file
     * @property int $is_seen 0=unseen, 1=seen
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $load_from
     * @property int $is_synced
     * @property-read $file_path attribute
     * @property LiveChat $liveChat
     * @method BelongsTo|_IH_LiveChat_QB liveChat()
     * @method static _IH_LiveChatMessage_QB onWriteConnection()
     * @method _IH_LiveChatMessage_QB newQuery()
     * @method static _IH_LiveChatMessage_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_LiveChatMessage_QB query()
     * @method static _IH_LiveChatMessage_QB with(array|string $relations)
     * @method _IH_LiveChatMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LiveChatMessage_C|LiveChatMessage[] all($columns = ['*'])
     * @ownLinks live_chat_id,\Modules\Chat\Entities\LiveChat,id
     * @mixin _IH_LiveChatMessage_QB
     */
    class LiveChatMessage extends Model {}
    
    /**
     * @property int $id
     * @property int $freelancer_id
     * @property int $client_id
     * @property float $price
     * @property string|null $description
     * @property string|null $deadline
     * @property int $status 0=pending, 1=active, 2=reject
     * @property int $revision
     * @property int $revision_left
     * @property string|null $attachment
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $client
     * @method BelongsTo|_IH_User_QB client()
     * @property User $freelancer
     * @method BelongsTo|_IH_User_QB freelancer()
     * @property _IH_OfferMilestone_C|OfferMilestone[] $milestones
     * @property-read int $milestones_count
     * @method HasMany|_IH_OfferMilestone_QB milestones()
     * @method static _IH_Offer_QB onWriteConnection()
     * @method _IH_Offer_QB newQuery()
     * @method static _IH_Offer_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Offer_QB query()
     * @method static _IH_Offer_QB with(array|string $relations)
     * @method _IH_Offer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Offer_C|Offer[] all($columns = ['*'])
     * @foreignLinks id,\Modules\Chat\Entities\OfferMilestone,offer_id
     * @mixin _IH_Offer_QB
     */
    class Offer extends Model {}
    
    /**
     * @property int $id
     * @property int $offer_id
     * @property string $title
     * @property string $description
     * @property float $price
     * @property string|null $deadline
     * @property int $status 0=pending, 1=active, 2=complete, 3=cancel
     * @property int $revision
     * @property int $revision_left
     * @property string|null $attachment
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_OfferMilestone_QB onWriteConnection()
     * @method _IH_OfferMilestone_QB newQuery()
     * @method static _IH_OfferMilestone_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_OfferMilestone_QB query()
     * @method static _IH_OfferMilestone_QB with(array|string $relations)
     * @method _IH_OfferMilestone_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OfferMilestone_C|OfferMilestone[] all($columns = ['*'])
     * @ownLinks offer_id,\Modules\Chat\Entities\Offer,id
     * @mixin _IH_OfferMilestone_QB
     */
    class OfferMilestone extends Model {}
}