<?php //4837f172e0533c878a425410fd9b1c7a
/** @noinspection all */

namespace Modules\CountryManage\Entities {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_City_C;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_City_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_Country_C;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_Country_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_State_C;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_State_QB;
    
    /**
     * @property int $id
     * @property int|null $country_id
     * @property int $state_id
     * @property string $city
     * @property int $status 0=inactive 1=active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Country|null $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property State $state
     * @method BelongsTo|_IH_State_QB state()
     * @method static _IH_City_QB onWriteConnection()
     * @method _IH_City_QB newQuery()
     * @method static _IH_City_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_City_QB query()
     * @method static _IH_City_QB with(array|string $relations)
     * @method _IH_City_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_City_C|City[] all($columns = ['*'])
     * @ownLinks country_id,\Modules\CountryManage\Entities\Country,id|state_id,\Modules\CountryManage\Entities\State,id
     * @foreignLinks id,\App\Models\User,city_id|id,\App\Models\IdentityVerification,city_id
     * @mixin _IH_City_QB
     */
    class City extends Model {}
    
    /**
     * @property int $id
     * @property string $country
     * @property int $status 0=inactive 1=active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Country_QB onWriteConnection()
     * @method _IH_Country_QB newQuery()
     * @method static _IH_Country_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Country_QB query()
     * @method static _IH_Country_QB with(array|string $relations)
     * @method _IH_Country_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Country_C|Country[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\User,country_id|id,\Modules\CountryManage\Entities\State,country_id|id,\Modules\CountryManage\Entities\City,country_id|id,\App\Models\UserExperience,country_id|id,\App\Models\IdentityVerification,country_id
     * @mixin _IH_Country_QB
     */
    class Country extends Model {}
    
    /**
     * @property int $id
     * @property int|null $country_id
     * @property string $state
     * @property int $status 0=inactive 1=active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $timezone
     * @property Country|null $country
     * @method BelongsTo|_IH_Country_QB country()
     * @method static _IH_State_QB onWriteConnection()
     * @method _IH_State_QB newQuery()
     * @method static _IH_State_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_State_QB query()
     * @method static _IH_State_QB with(array|string $relations)
     * @method _IH_State_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_State_C|State[] all($columns = ['*'])
     * @ownLinks country_id,\Modules\CountryManage\Entities\Country,id
     * @foreignLinks id,\App\Models\User,state_id|id,\Modules\CountryManage\Entities\City,state_id|id,\App\Models\UserExperience,state_id|id,\App\Models\IdentityVerification,state_id
     * @mixin _IH_State_QB
     */
    class State extends Model {}
}