<?php //bdbe9484a0b0017969a159a0b20963f3
/** @noinspection all */

namespace Modules\Service\Entities {

    use App\Models\JobPost;
    use App\Models\Project;
    use App\Models\Skill;
    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_JobPost_C;
    use LaravelIdea\Helper\App\Models\_IH_JobPost_QB;
    use LaravelIdea\Helper\App\Models\_IH_Project_C;
    use LaravelIdea\Helper\App\Models\_IH_Project_QB;
    use LaravelIdea\Helper\App\Models\_IH_Skill_C;
    use LaravelIdea\Helper\App\Models\_IH_Skill_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogPost_C;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogPost_QB;
    use LaravelIdea\Helper\Modules\Service\Entities\_IH_Category_C;
    use LaravelIdea\Helper\Modules\Service\Entities\_IH_Category_QB;
    use LaravelIdea\Helper\Modules\Service\Entities\_IH_SubCategory_C;
    use LaravelIdea\Helper\Modules\Service\Entities\_IH_SubCategory_QB;
    use Modules\Blog\Entities\BlogPost;
    
    /**
     * @property int $id
     * @property string $category
     * @property int $status 0=inactive 1=active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $slug
     * @property string|null $image
     * @property string $short_description
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property int|null $selected_category
     * @property _IH_BlogPost_C|BlogPost[] $blogs
     * @property-read int $blogs_count
     * @method HasMany|_IH_BlogPost_QB blogs()
     * @property _IH_JobPost_C|JobPost[] $jobs
     * @property-read int $jobs_count
     * @method HasMany|_IH_JobPost_QB jobs()
     * @property _IH_Project_C|Project[] $projects
     * @property-read int $projects_count
     * @method HasMany|_IH_Project_QB projects()
     * @property _IH_Skill_C|Skill[] $skills
     * @property-read int $skills_count
     * @method HasMany|_IH_Skill_QB skills()
     * @property _IH_SubCategory_C|SubCategory[] $sub_categories
     * @property-read int $sub_categories_count
     * @method HasMany|_IH_SubCategory_QB sub_categories()
     * @property _IH_User_C|User[] $users
     * @property-read int $users_count
     * @method BelongsToMany|_IH_User_QB users()
     * @method static _IH_Category_QB onWriteConnection()
     * @method _IH_Category_QB newQuery()
     * @method static _IH_Category_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Category_QB query()
     * @method static _IH_Category_QB with(array|string $relations)
     * @method _IH_Category_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Category_C|Category[] all($columns = ['*'])
     * @foreignLinks id,\Modules\Service\Entities\SubCategory,category_id|id,\App\Models\Skill,category_id|id,\App\Models\UserWork,category_id|id,\App\Models\Project,category_id|id,\Modules\Blog\Entities\BlogPost,category_id|id,\App\Models\CategoryUser,category_id
     * @mixin _IH_Category_QB
     */
    class Category extends Model {}
    
    /**
     * @property int $id
     * @property string $sub_category
     * @property int $category_id
     * @property int $status 0=inactive 1=active
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $slug
     * @property string|null $image
     * @property string $short_description
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_JobPost_C|JobPost[] $jobs
     * @property-read int $jobs_count
     * @method BelongsToMany|_IH_JobPost_QB jobs()
     * @property _IH_Project_C|Project[] $projects
     * @property-read int $projects_count
     * @method BelongsToMany|_IH_Project_QB projects()
     * @property _IH_Skill_C|Skill[] $skills
     * @property-read int $skills_count
     * @method HasMany|_IH_Skill_QB skills()
     * @method static _IH_SubCategory_QB onWriteConnection()
     * @method _IH_SubCategory_QB newQuery()
     * @method static _IH_SubCategory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SubCategory_QB query()
     * @method static _IH_SubCategory_QB with(array|string $relations)
     * @method _IH_SubCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubCategory_C|SubCategory[] all($columns = ['*'])
     * @ownLinks category_id,\Modules\Service\Entities\Category,id
     * @foreignLinks id,\App\Models\Skill,sub_category_id|id,\App\Models\UserWork,sub_category_id|id,\App\Models\ProjectSubCategory,sub_category_id|id,\App\Models\JobPostSubCategory,sub_category_id|id,\App\Models\SubCategoryUser,sub_category_id
     * @mixin _IH_SubCategory_QB
     */
    class SubCategory extends Model {}
}