<?php //93599209180ff3d6f7eaf0429aca6098
/** @noinspection all */

namespace Modules\Wallet\Entities {

    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletHistory_C;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletHistory_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_Wallet_C;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_Wallet_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WithdrawGateway_C;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WithdrawGateway_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WithdrawRequest_C;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WithdrawRequest_QB;
    
    /**
     * @property int $id
     * @property int $user_id
     * @property float $balance
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property float $remaining_balance
     * @property float $withdraw_amount
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Wallet_QB onWriteConnection()
     * @method _IH_Wallet_QB newQuery()
     * @method static _IH_Wallet_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Wallet_QB query()
     * @method static _IH_Wallet_QB with(array|string $relations)
     * @method _IH_Wallet_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Wallet_C|Wallet[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_Wallet_QB
     */
    class Wallet extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string|null $payment_gateway
     * @property string|null $payment_status
     * @property float $amount
     * @property string|null $transaction_id
     * @property string $manual_payment_image
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $email_send
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_WalletHistory_QB onWriteConnection()
     * @method _IH_WalletHistory_QB newQuery()
     * @method static _IH_WalletHistory_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_WalletHistory_QB query()
     * @method static _IH_WalletHistory_QB with(array|string $relations)
     * @method _IH_WalletHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_WalletHistory_C|WalletHistory[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_WalletHistory_QB
     */
    class WalletHistory extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $field
     * @property int $status 1=active, 2=inactive
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_WithdrawGateway_QB onWriteConnection()
     * @method _IH_WithdrawGateway_QB newQuery()
     * @method static _IH_WithdrawGateway_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_WithdrawGateway_QB query()
     * @method static _IH_WithdrawGateway_QB with(array|string $relations)
     * @method _IH_WithdrawGateway_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_WithdrawGateway_C|WithdrawGateway[] all($columns = ['*'])
     * @mixin _IH_WithdrawGateway_QB
     */
    class WithdrawGateway extends Model {}
    
    /**
     * @property int $id
     * @property float $amount
     * @property int $gateway_id
     * @property int $user_id
     * @property int $status 1=pending, 2=complete, 3=cancel
     * @property string $gateway_fields
     * @property string|null $note
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property WithdrawGateway $gateway_name
     * @method BelongsTo|_IH_WithdrawGateway_QB gateway_name()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_WithdrawRequest_QB onWriteConnection()
     * @method _IH_WithdrawRequest_QB newQuery()
     * @method static _IH_WithdrawRequest_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_WithdrawRequest_QB query()
     * @method static _IH_WithdrawRequest_QB with(array|string $relations)
     * @method _IH_WithdrawRequest_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_WithdrawRequest_C|WithdrawRequest[] all($columns = ['*'])
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_WithdrawRequest_QB
     */
    class WithdrawRequest extends Model {}
}